#include <iostream>
#include <vector>
#include <string>
#include <math.h>
#include <cstdio>
#include <algorithm>
#include <map>
#include <set>
#include <queue>
#include <stack>
#include <deque>
#include <cstring>
#define endl '\n'

using namespace std;
typedef long long ll;

ll n, m;

vector<ll>d[100007];

ll used[100007], step[100007], parent[100007];
deque<ll>cur;

vector<ll>ans;

bool ok = false;

void dfs(ll v, ll par){
    if(ans.size() > 0)
        return;
    
    //cout << v << ' '  << par << endl;
    
    step[v] = step[par] + 1;
    used[v] = 1;
    parent[v] = par;
    
    for(auto i: d[v]){
        if(i == par)
            continue;
        if(used[i] != 1)
            dfs(i, v);
        else{
            if(step[v] - step[i] + 1 == n && i == 1){
                ll o = v;
                
                ans.push_back(i);
                
                while(1){
                    ans.push_back(o);
                    o = parent[o];
                    
                    if(o == i){
                        ans.push_back(i);
                        break;
                    }
                }
                
                return;
            }
        }
    }
    
    //cout << "__" << endl;
    step[v] = -1;
    parent[v] = -1;
    used[v] = 2;
}

void check(ll v, ll par){
    if(ok)
        return;
    used[v] = 1;
    
    for(auto i: d[v]){
        if(i != par && used[i] == 1){
            ok = true;
            return;
        }
        
        if(used[i] == 0)
            check(i, v);
    }
    used[v] = 2;
}

int main(){
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    
    cin >> n >> m;
    
    vector<set<ll>>mp(n + 1);
    
    for(int i = 0; i < m; i++){
        ll a, b;
        cin >> a >> b;
        
        d[a].push_back(b);
        mp[a].insert(b);
    }
    
    check(1, 0);
    if(!ok){
        cout << "NO" << endl;
        return 0;
    }
    
    for(int i = 1; i<= n; i++)used[i] = 0;
    
    dfs(1, 0);
    
    if(ans.size() == 0)
        cout << "NO" << endl;
    else{
        reverse(ans.begin(), ans.end());
        if(ans[0] != ans[ans.size() - 1] || ans[0] != 1 || ans[ans.size() - 1] != 1){
            cout << "NO" << endl;
            return 0;
        }
        
        set<ll>st;
        
        for(auto i: ans)
            st.insert(i);
        
        if(st.size() != n){
            cout << "NO" << endl;
            return 0;
        }
        
        bool ok2 = false;
        
        for(int i = 0; i < ans.size() - 1; i++){
            if(!mp[ans[i]].count(ans[i + 1])){
                ok2 = true;
                break;
            }
        }
        if(ok2){
            cout << "NO" << endl;
            return 0;
        }
        
        cout << "YES" << endl;
        
        
        
        for(auto i: ans)
            cout << i << ' ';
        cout << endl;
    }
    
    return 0;
}
